<?php
/*======================================================================*\
|| #################################################################### ||
|| # Post by Proxy by MarcoH64
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006 MarcoH64
|| # This file may not be redistributed in whole or significant part. # ||
|| #################################################################### ||
\*======================================================================*/

// ======================== mh_pbp_fetch_post_proxy_users =======================

function mh_pbp_fetch_post_proxy_users($current_userid = null)
{
	global $vbulletin;
	$post_proxy_users = array();
	
	// Fetch usergroupids
	$mh_pbp_post_on_behalf_groupids = explode(",", $vbulletin->userinfo['permissions']['mh_pbp_post_on_behalf']);
	if ($vbulletin->userinfo['membergroupids'])
	{
		foreach (explode(",", $vbulletin->userinfo['membergroupids']) AS $data)
		{
			$mh_pbp_post_on_behalf_groupids = array_merge($mh_pbp_post_on_behalf_groupids, ($vbulletin->usergroupcache[$data]['mh_pbp_post_on_behalf'] ? explode(",", $vbulletin->usergroupcache[$data]['mh_pbp_post_on_behalf']): array()));
		}
	}

	// Filter out double values and 0/empty values
	$mh_pbp_post_on_behalf_groupids = array_unique(array_diff($mh_pbp_post_on_behalf_groupids, array(0, "")));
	
	// Fetch users
	if (count($mh_pbp_post_on_behalf_groupids) > 0)
	{
		$mh_pbp_groupids = implode(",", $mh_pbp_post_on_behalf_groupids);
		$proxy_users = $vbulletin->db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user
				WHERE usergroupid IN ($mh_pbp_groupids)
			");
		while ($proxy_user = $vbulletin->db->fetch_array($proxy_users))
		{
			$post_proxy_users[$proxy_user[userid]] = $proxy_user['username'];
		}
	}

	// If a currentuserid is passed, we are editing a post. Let's check if the current user have permissions to the current poster
	// If we don't have permission to current poster, disable editing it.
	// Unless current user is the poster
	if ($current_userid AND !array_key_exists($current_userid, $post_proxy_users) AND $current_userid != $vbulletin->userinfo['userid'])
	{
		$post_proxy_users = array();
	}

	return $post_proxy_users;
}
// ======================== mh_pbp_fetch_pm_proxy_users =======================

function mh_pbp_fetch_pm_proxy_users()
{
	global $vbulletin;
	$pm_proxy_users = array();
	
	// Fetch usergroupids
	$mh_pbp_pm_on_behalf_groupids = explode(",", $vbulletin->userinfo['permissions']['mh_pbp_pm_on_behalf']);
	if ($vbulletin->userinfo['membergroupids'])
	{
		foreach (explode(",", $vbulletin->userinfo['membergroupids']) AS $data)
		{
			$mh_pbp_pm_on_behalf_groupids = array_merge($mh_pbp_pm_on_behalf_groupids, ($vbulletin->usergroupcache[$data]['mh_pbp_pm_on_behalf'] ? explode(",", $vbulletin->usergroupcache[$data]['mh_pbp_pm_on_behalf']): array()));
		}
	}

	// Filter out double values and 0/empty values
	$mh_pbp_pm_on_behalf_groupids = array_unique(array_diff($mh_pbp_pm_on_behalf_groupids, array(0, "")));
	
	// Fetch users
	if (count($mh_pbp_pm_on_behalf_groupids) > 0)
	{
		$mh_pbp_groupids = implode(",", $mh_pbp_pm_on_behalf_groupids);
		$proxy_users = $vbulletin->db->query_read("SELECT userid, username FROM " . TABLE_PREFIX . "user
				WHERE usergroupid IN ($mh_pbp_groupids)
			");
		while ($proxy_user = $vbulletin->db->fetch_array($proxy_users))
		{
			$pm_proxy_users[$proxy_user[userid]] = $proxy_user['username'];
		}
	}

	return $pm_proxy_users;
}

// #######################################################################
// 									mh_pbp_modify_template
function mh_pbp_modify_template(&$object, $productid, $template, $location, $default_search, $default_replace = null)
{
	global $vbulletin;
	
	// Switch to postbit legacy if needed
	if ($template == "postbit" AND $vbulletin->options['legacypostbit'])
	{
		$template = "postbit_legacy";
	}
	
	// If 'Dynamic Template Modification' Hack is installed, then let this handle the template modification
	// Otherwise, do the requested default modification
	if ($vbulletin->products['mh_dtm'])
	{
		require_once(DIR . '/includes/functions_mh_dtm.php');
		mh_dtm_modify_template($object, $productid, $template, $location, $default_search, $default_replace);
	}
	else
	{
			$object["$template"] = str_replace(
				"$default_search"
			,	"$default_replace"
			,	$object["$template"]
		);
	}
	return true;
}


?>